# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{inifile}
  s.version = "0.4.1"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Tim Pease"]
  s.date = %q{2011-02-22}
  s.description = %q{This is a native Ruby package for reading and writing INI files.

Although made popular by Windows, INI files can be used on any system thanks
to their flexibility. They allow a program to store configuration data, which
can then be easily parsed and changed. Two notable systems that use the INI
format are Samba and Trac.
  
== SYNOPSIS:

An initialization file, or INI file, is a configuration file that contains
configuration data for Microsoft Windows based applications. Starting with
Windows 95, the INI file format was superseded but not entirely replaced by
a registry database in Microsoft operating systems.

Although made popular by Windows, INI files can be used on any system thanks
to their flexibility. They allow a program to store configuration data, which
can then be easily parsed and changed.}
  s.email = %q{tim.pease@gmail.com}
  s.extra_rdoc_files = ["History.txt", "README.txt"]
  s.files = ["History.txt", "README.txt", "Rakefile", "lib/inifile.rb", "test/data/bad_1.ini", "test/data/bad_2.ini", "test/data/browscap.ini", "test/data/comment.ini", "test/data/good.ini", "test/data/mixed_comment.ini", "test/data/multiline.ini", "test/data/param.ini", "test/test_inifile.rb"]
  s.homepage = %q{http://gemcutter.org/gems/inifile}
  s.rdoc_options = ["--main", "README.txt"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{inifile}
  s.rubygems_version = %q{1.5.2}
  s.summary = %q{INI file reader and writer}
  s.test_files = ["test/test_inifile.rb"]

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<bones-git>, [">= 1.2.4"])
      s.add_development_dependency(%q<bones>, [">= 3.6.5"])
    else
      s.add_dependency(%q<bones-git>, [">= 1.2.4"])
      s.add_dependency(%q<bones>, [">= 3.6.5"])
    end
  else
    s.add_dependency(%q<bones-git>, [">= 1.2.4"])
    s.add_dependency(%q<bones>, [">= 3.6.5"])
  end
end
